package d2sguide;

import java.io.*;
import java.util.*;

import chemaxon.naming.DocumentExtractor;
import chemaxon.naming.DocumentExtractor.Hit;

import org.apache.http.client.ResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;


public class Demo2 {

    private static String loadURL(String url) throws Exception {
        
        HttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(url);

            ResponseHandler<String> responseHandler = new BasicResponseHandler();
            String responseBody = httpclient.execute(httpget, responseHandler);
            return responseBody;

        } finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    public static void main(String[] args) throws Exception {

            
        String pagecontent = loadURL("http://simple.wikipedia.org/wiki/Aspirin");
    
        
        //process the page and get the results
        DocumentExtractor x = new DocumentExtractor();
        x.processHTML(new StringReader(pagecontent));
        List<Hit> hits = x.getHits();
                    
        
        //return the name by which the structure was imported
        for (Hit hit : hits) {
            System.out.println(hit.structure.getName());
        }        


        System.exit(0);

    }

}
