package d2sguide;

import java.io.*;
import java.net.*;
import java.util.*;

import chemaxon.naming.DocumentExtractor;
import chemaxon.naming.DocumentExtractor.Hit;


public class Demo3 {

    public static void main(String[] args) throws Exception {

        
        FileInputStream pdf = null;
        try {
            pdf = new FileInputStream("test.pdf");
            DocumentExtractor x = DocumentExtractor.readPDF(pdf);
            x.processPlainText();
            List<Hit> hits = x.getHits();        

            //show where each structure was found
            for (Hit hit : hits) {
                System.out.println(hit.text + 
                  " found on page " + hit.getPageNumber());
            }
            
        } finally {
	        if (pdf != null) {
		        pdf.close();
	        }
        }        

        System.exit(0);

    }

}
