package d2sguide;

import java.io.*;
import java.net.*;
import java.util.*;

import chemaxon.naming.DocumentExtractor;
import chemaxon.naming.DocumentExtractor.Hit;

import org.apache.http.client.ResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;


public class Demo4 {

    //html markup for the individual hits
    public static String prefix = "<span class=\"chemicalcompound\" data-structurename=\"%n\">";
    public static String suffix = "</span>";
    
    
    private static String loadURL(String url) throws Exception {
        
        HttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(url);

            ResponseHandler<String> responseHandler = new BasicResponseHandler();
            String responseBody = httpclient.execute(httpget, responseHandler);
            return responseBody;

        } finally {
            httpclient.getConnectionManager().shutdown();
        }
    }


    public static void main(String[] args) throws Exception {

        
        String pagecontent = loadURL("http://en.wikipedia.org/wiki/Penicillin");
            
            
        //process the page and get the results
        DocumentExtractor x = new DocumentExtractor();
        x.processHTML(new StringReader(pagecontent));
        List<Hit> hits = x.getHits();
                    
        
        //return the name by which the structure was imported
        int modification = 0;
        for (Hit hit : hits) {

            //add the corrected name of this hit 
            String current_prefix = prefix.replace("%n", hit.structure.getName());
            
            
            //add the modified prefix before, and the suffix after this hit
            pagecontent = pagecontent.substring(0, hit.position - 1 + modification) +
                current_prefix + hit.text + suffix +
                pagecontent.substring(hit.position - 1 + modification + hit.text.length());
                
                
            //update the amount of modification performed so far
            modification += current_prefix.length() + suffix.length();
        }
        
        
        System.out.println(pagecontent);
        

        System.exit(0);

    }

}
