package d2sguide;

import java.io.*;
import java.sql.*;
import java.util.*;

import chemaxon.naming.DocumentExtractor;
import chemaxon.naming.DocumentExtractor.Hit;
import chemaxon.jchem.db.*;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;

import org.apache.http.client.ResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;


public class Demo6 {

    private ConnectionHandler database = null;
    private UpdateHandler uh = null;
    
    private static void addStructure(Hit hit) throws SQLException {
    
        String struct = hit.structure.toFormat("mrv");
        uh.setStructure(struct);
        
        uh.setValueForAdditionalColumn(1, hit.position, java.sql.Types.INTEGER);
        uh.setValueForAdditionalColumn(2, hit.text, java.sql.Types.VARCHAR);
        
        uh.execute();

    }
    
    
    private static String loadURL(String url) throws Exception {
        
        HttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(url);

            ResponseHandler<String> responseHandler = new BasicResponseHandler();
            String responseBody = httpclient.execute(httpget, responseHandler);
            return responseBody;

        } finally {
            httpclient.getConnectionManager().shutdown();
        }
    }    
    

    public static void main(String[] args) throws Exception {

        try {
            
            database = new ConnectionHandler();
            database.setDriver(DatabaseConstants.MYSQL_DRIVER);
            database.setUrl("jdbc:mysql://localhost/database");
            database.setLoginName("username");
            database.setPassword("password");
            
            database.connectToDatabase();

            uh = new UpdateHandler(database, UpdateHandler.INSERT, "structures", "position, text");
            

            String pagecontent = loadURL("http://en.wikipedia.org/wiki/Penicillin");
                
                
            //process the page and get the results
            DocumentExtractor x = new DocumentExtractor();
            x.processHTML(new StringReader(pagecontent));
            List<Hit> hits = x.getHits();
                        
            
            //add each hit to the JChem structure table
            for (Hit hit : hits) {        
                addStructure(hit);
            }


        } finally {
        
            if (uh != null) {
                uh.close();
            }
            
            if (database != null) {
                database.close();
            }
            
        }

    }

}
