package custom.checkers;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import custom.checkers.DuplicateAtomMapChecker.ReactionSide;

public class DuplicateAtomMapCheckerEditor extends DefaultCheckerEditor {

	/** the main component */
	private JPanel mainPanel = null;

	/** radio button for reactant only */
	private JRadioButton reactantRadio = null;

	/** radio button for product only */
	private JRadioButton productRadio = null;

	/** radio button for both */
	private JRadioButton bothRadio = null;

	/** the checker instance being edited */
	private DuplicateAtomMapChecker checker = null;

	/**
	 * Constructs an editor component for duplicate atom map checker.
	 */
	public DuplicateAtomMapCheckerEditor() {
		ButtonGroup group = new ButtonGroup();
		group.add(getReactantRadio());
		group.add(getProductRadio());
		group.add(getBothRadio());
	}

	@Override
	protected Component getCustomComponent() {
		if (mainPanel == null) {

			// create a panel and set up a layout
			mainPanel = new JPanel();
			mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));

			// add control components
			mainPanel.add(getReactantRadio());
			mainPanel.add(getProductRadio());
			mainPanel.add(getBothRadio());

			// set up some design
			mainPanel.setBackground(Color.WHITE);
			mainPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));

		}
		return mainPanel;
	}

	@Override
	public JComponent getEditorComponent(StructureChecker checker) {
		if (checker instanceof DuplicateAtomMapChecker) {
			this.checker = (DuplicateAtomMapChecker) checker;
			switch (this.checker.getReactionSide()) {
			case REACTANT:
				getReactantRadio().setSelected(true);
				break;
			case PRODUCT:
				getProductRadio().setSelected(true);
				break;
			case BOTH:
			default:
				getBothRadio().setSelected(true);
				break;
			}
		} else {
			this.checker = null;
		}
		return super.getEditorComponent(this.checker);
	}

	/**
	 * Initializes and returns the radio button for reactant only selection.
	 * 
	 * @return the radio button for reactant only selection
	 */
	private JRadioButton getReactantRadio() {
		if (reactantRadio == null) {
			reactantRadio = new JRadioButton("Search in reactants");
			reactantRadio.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					if (reactantRadio.isSelected()) {
						checker.setReactionSide(ReactionSide.REACTANT);
					}
				}
			});
		}
		return reactantRadio;
	}

	/**
	 * Initializes and returns the radio button for product only selection.
	 * 
	 * @return the radio button for product only selection
	 */
	private JRadioButton getProductRadio() {
		if (productRadio == null) {
			productRadio = new JRadioButton("Search in products");
			productRadio.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					if (productRadio.isSelected()) {
						checker.setReactionSide(ReactionSide.PRODUCT);
					}
				}
			});

		}
		return productRadio;
	}

	/**
	 * Initializes and returns the radio button for both selection.
	 * 
	 * @return the radio button for both selection
	 */
	private JRadioButton getBothRadio() {
		if (bothRadio == null) {
			bothRadio = new JRadioButton("Search in reactants and products");
			bothRadio.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					if (bothRadio.isSelected()) {
						checker.setReactionSide(ReactionSide.BOTH);
					}
				}
			});

		}
		return bothRadio;
	}
	
}
